import timm
import torch
from efficientnet_pytorch import EfficientNet
import torchvision
from constants import DEVICE

# # Inception
# googlenet = torchvision.models.googlenet(pretrained=True).eval().to(DEVICE)
# inception_v3 = torchvision.models.inception_v3(pretrained=True).eval().to(DEVICE)
# inception_v4 = timm.create_model('inception_v4', pretrained=True).eval().to(DEVICE)
#
# # Inception-ResNet
# inception_resnet_v2 = timm.create_model('inception_resnet_v2', pretrained=True).eval().to(DEVICE)
#
# # ResNet-v1
# resnet18 = torchvision.models.resnet18(pretrained=True).eval().to(DEVICE)
# resnet34 = torchvision.models.resnet34(pretrained=True).eval().to(DEVICE)
# resnet50 = torchvision.models.resnet50(pretrained=True).eval().to(DEVICE)
# resnet101 = torchvision.models.resnet101(pretrained=True).eval().to(DEVICE)
# resnet152 = torchvision.models.resnet152(pretrained=True).eval().to(DEVICE)
#
# # VGG
# vgg11 = torchvision.models.vgg11(pretrained=True).eval().to(DEVICE)
# vgg13 = torchvision.models.vgg13(pretrained=True).eval().to(DEVICE)
# vgg16 = torchvision.models.vgg16(pretrained=True).eval().to(DEVICE)
# vgg19 = torchvision.models.vgg19(pretrained=True).eval().to(DEVICE)
#
# # DenseNet
# densenet121 = torchvision.models.densenet121(pretrained=True).eval().to(DEVICE)
# densenet169 = torchvision.models.densenet169(pretrained=True).eval().to(DEVICE)
# densenet201 = torchvision.models.densenet201(pretrained=True).eval().to(DEVICE)
# densenet161 = torchvision.models.densenet161(pretrained=True).eval().to(DEVICE)

# # EfficientNet
# efficientnet_b0 = torchvision.models.efficientnet_b0(pretrained=True).eval().to(DEVICE)
# efficientnet_b1 = torchvision.models.efficientnet_b1(pretrained=True).eval().to(DEVICE)
# efficientnet_b2 = torchvision.models.efficientnet_b2(pretrained=True).eval().to(DEVICE)
# efficientnet_b3 = torchvision.models.efficientnet_b3(pretrained=True).eval().to(DEVICE)
# efficientnet_b4 = torchvision.models.efficientnet_b4(pretrained=True).eval().to(DEVICE)
# efficientnet_b5 = torchvision.models.efficientnet_b5(pretrained=True).eval().to(DEVICE)
# efficientnet_b6 = torchvision.models.efficientnet_b6(pretrained=True).eval().to(DEVICE)
# efficientnet_b7 = torchvision.models.efficientnet_b7(pretrained=True).eval().to(DEVICE)

# adversarially trained
# adv_inception_v3 = timm.create_model('adv_inception_v3', pretrained=True).eval().to(DEVICE)
# ens_adv_inception_resnet_v2 = timm.create_model('ens_adv_inception_resnet_v2', pretrained=True).eval().to(DEVICE)
adv_efficientnet_b0 = EfficientNet.from_pretrained("efficientnet-b0", advprop=True).eval().to(DEVICE)
adv_efficientnet_b1 = EfficientNet.from_pretrained("efficientnet-b1", advprop=True).eval().to(DEVICE)
adv_efficientnet_b2 = EfficientNet.from_pretrained("efficientnet-b2", advprop=True).eval().to(DEVICE)
adv_efficientnet_b3 = EfficientNet.from_pretrained("efficientnet-b3", advprop=True).eval().to(DEVICE)
adv_efficientnet_b4 = EfficientNet.from_pretrained("efficientnet-b4", advprop=True).eval().to(DEVICE)
adv_efficientnet_b5 = EfficientNet.from_pretrained("efficientnet-b5", advprop=True).eval().to(DEVICE)
adv_efficientnet_b6 = EfficientNet.from_pretrained("efficientnet-b6", advprop=True).eval().to(DEVICE)
adv_efficientnet_b7 = EfficientNet.from_pretrained("efficientnet-b7", advprop=True).eval().to(DEVICE)

# models
models = {
    # 'googlenet': googlenet,
    # 'inception_v3': inception_v3,
    # 'inception_v4': inception_v4,
    # 'inception_resnet_v2': inception_resnet_v2,
    # 'resnet18': resnet18,
    # 'resnet34': resnet34,
    # 'resnet50': resnet50,
    # 'resnet101': resnet101,
    # 'resnet152': resnet152,
    # 'vgg11': vgg11,
    # 'vgg13': vgg13,
    # 'vgg16': vgg16,
    # 'vgg19': vgg19,
    # 'densenet121': densenet121,
    # 'densenet169': densenet169,
    # 'densenet201': densenet201,
    # 'densenet161': densenet161,
    # 'efficientnet_b0': efficientnet_b0,
    # 'efficientnet_b1': efficientnet_b1,
    # 'efficientnet_b2': efficientnet_b2,
    # 'efficientnet_b3': efficientnet_b3,
    # 'efficientnet_b4': efficientnet_b4,
    # 'efficientnet_b5': efficientnet_b5,
    # 'efficientnet_b6': efficientnet_b6,
    # 'efficientnet_b7': efficientnet_b7,
    # 'adv_inception_v3': adv_inception_v3,
    # 'ens_adv_inception_resnet_v2': ens_adv_inception_resnet_v2,
    'adv_efficientnet_b0': adv_efficientnet_b0,
    'adv_efficientnet_b1': adv_efficientnet_b1,
    'adv_efficientnet_b2': adv_efficientnet_b2,
    'adv_efficientnet_b3': adv_efficientnet_b3,
    'adv_efficientnet_b4': adv_efficientnet_b4,
    'adv_efficientnet_b5': adv_efficientnet_b5,
    'adv_efficientnet_b6': adv_efficientnet_b6,
    'adv_efficientnet_b7': adv_efficientnet_b7
}

sizes = {
    'googlenet': 299,
    'inception_v3': 299,
    'inception_v4': 299,
    'inception_resnet_v2': 299,
    'resnet18': 224,
    'resnet34': 224,
    'resnet50': 224,
    'resnet101': 224,
    'resnet152': 224,
    'vgg11': 224,
    'vgg13': 224,
    'vgg16': 224,
    'vgg19': 224,
    'densenet121': 224,
    'densenet169': 224,
    'densenet201': 224,
    'densenet161': 224,
    'efficientnet_b0': 224,
    'efficientnet_b1': 224,
    'efficientnet_b2': 224,
    'efficientnet_b3': 224,
    'efficientnet_b4': 224,
    'efficientnet_b5': 224,
    'efficientnet_b6': 224,
    'efficientnet_b7': 224,
    'adv_inception_v3': 299,
    'ens_adv_inception_resnet_v2': 299,
    'adv_efficientnet_b0': 224,
    'adv_efficientnet_b1': 224,
    'adv_efficientnet_b2': 224,
    'adv_efficientnet_b3': 224,
    'adv_efficientnet_b4': 224,
    'adv_efficientnet_b5': 224,
    'adv_efficientnet_b6': 224,
    'adv_efficientnet_b7': 224
}

intermediate_layer_names = {
    'inception_v3': 'Mixed_5b',
    'inception_resnet_v2': 'conv2d_4a',
    'resnet152': 'layer2.7.relu',
    'vgg16': 'features.15'
}
